/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.properties;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.components.properties.PropLocalization;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="New Locale Data")
@Description(value={"Returns the a new locale data for the given locale and the given value.", "You have to provide the locale using its code (list can be found here: https://discord.com/developers/docs/reference#locales) and the value to set.", "Documentation: https://docs.disky.me/advanced-stuff/slash-commands#using-localizations-v4.3.0+"})
@Examples(value={"new locale data for \"FR\" as \"niveau\""})
public class ExprNewLocaleData
extends SimpleExpression<PropLocalization.LocaleData> {
    private Expression<String> exprLocale;
    private Expression<String> exprValue;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprLocale = exprs[0];
        this.exprValue = exprs[1];
        return true;
    }

    protected PropLocalization.LocaleData @NotNull [] get(@NotNull Event e) {
        String locale = EasyElement.parseSingle(this.exprLocale, e, null);
        String value = EasyElement.parseSingle(this.exprValue, e, null);
        if (EasyElement.anyNull((Object)this, locale, value)) {
            return new PropLocalization.LocaleData[0];
        }
        DiscordLocale discordLocale = DiscordLocale.from(locale);
        if (discordLocale == DiscordLocale.UNKNOWN) {
            Skript.error((String)("Unknown locale: " + locale));
            Skript.error((String)"You can find a list of Discord Locales, with their code, here: https://discord.com/developers/docs/reference#locale");
            return new PropLocalization.LocaleData[0];
        }
        return new PropLocalization.LocaleData[]{new PropLocalization.LocaleData(discordLocale, value)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends PropLocalization.LocaleData> getReturnType() {
        return PropLocalization.LocaleData.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "new locale data for " + this.exprLocale.toString(e, debug) + " with value " + this.exprValue.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewLocaleData.class, PropLocalization.LocaleData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"new local[e] [data] for %string% (as|with [value]) %string%"});
    }
}

