/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.itsthesky.disky.api.skript.EasyPropertyCondition;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Member / Bot is in Thread")
@Description(value={"Check if a specific member or bot is in a guild thread.", "Useful to avoid exception while using join & leave effects."})
public class BotMemberIsInThread
extends EasyPropertyCondition<Object> {
    private Expression<ThreadChannel> exprThread;

    @Override
    public boolean check(Event e, Object entity) {
        String id = entity instanceof Member ? ((Member)entity).getId() : ((Bot)entity).getInstance().getSelfUser().getId();
        ThreadChannel thread = (ThreadChannel)this.exprThread.getSingle(e);
        if (id == null || thread == null) {
            return false;
        }
        boolean contains = thread.getMembers().stream().filter(member -> member.getId().equalsIgnoreCase(id)).findAny().orElse(null) != null;
        return this.isNegated() != contains;
    }

    @Override
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprThread = exprs[0];
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    static {
        BotMemberIsInThread.register(BotMemberIsInThread.class, PropertyCondition.PropertyType.BE, "in [the] thread %threadchannel%", "member/bot");
    }
}

