/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.itsthesky.disky.api.events.specific.MessageEvent;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Message is From Guild")
@Description(value={"Check either a message(related event come from a guild or from private messages.", "This condition work with every event where a message is sent / received."})
@Examples(value={"if event is from guild:", "if message come from private message:"})
public class MessageOrigin
extends Condition {
    private boolean checkFromGuild;

    public boolean check(@NotNull Event e) {
        return this.checkFromGuild == ((MessageEvent)e).isFromGuild();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the message come from " + (this.checkFromGuild ? "guild" : "private message");
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        boolean bl = this.checkFromGuild = matchedPattern == 0;
        if (EasyElement.containsInterfaces(MessageEvent.class)) {
            return true;
        }
        Skript.error((String)"The 'message origin' condition can only be used in a message receive event.");
        return false;
    }

    static {
        Skript.registerCondition(MessageOrigin.class, (String[])new String[]{"[the] (message|event) (is coming|come from|is from) guild [channel]", "[the] (message|event) (is coming|come from|is from) (dm|(private|direct) message) [channel]"});
    }
}

