/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.managers.channel.concrete.ThreadChannelManager;
import net.itsthesky.disky.DiSky;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Archive / Unarchive Thread")
@Description(value={"Archive or unarchive a specific thread."})
@Examples(value={"archive event-threadchannel", "unarchive thread channel with id \"000\""})
@Since(value={"4.4.0"})
public class ArchiveUnarchiveThread
extends AsyncEffect {
    private Expression<ThreadChannel> exprThread;
    private boolean archived;

    public boolean init(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprThread = expressions[0];
        this.archived = i == 0;
        return true;
    }

    public void execute(@NotNull Event e) {
        ThreadChannel thread = (ThreadChannel)this.exprThread.getSingle(e);
        if (thread == null) {
            return;
        }
        ThreadChannelManager manager = thread.getManager();
        try {
            manager.setArchived(this.archived).complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return (this.archived ? "archive" : "unarchive") + " the thread " + this.exprThread.toString(e, debug);
    }

    static {
        Skript.registerEffect(ArchiveUnarchiveThread.class, (String[])new String[]{"archive [the] [thread] %threadchannel%", "unarchive [the] [thread] %threadchannel%"});
    }
}

