/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.effects.EffChange;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.regex.MatchResult;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.ReflectionUtils;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import net.itsthesky.disky.elements.changers.IAsyncGettableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AwaitEffect
extends AsyncEffect {
    private Effect effect;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        String rawEffect = ((MatchResult)parseResult.regexes.get(0)).group();
        this.effect = Effect.parse((String)rawEffect, (String)("Can't understand this effect: " + rawEffect));
        if (this.effect == null) {
            return false;
        }
        if (this.effect instanceof AsyncEffect) {
            Skript.warning((String)"You're using an async effect inside an await effect. No need to use await in this case as the effect is already async.");
        }
        return true;
    }

    protected void execute(@NotNull Event event) {
        if (this.effect instanceof EffChange) {
            EffChange change = (EffChange)this.effect;
            try {
                Object[] delta;
                Expression changed = (Expression)ReflectionUtils.getFieldValue(EffChange.class, "changed", change);
                if (changed == null) {
                    DiSky.debug("The changed expression is null, skipping the await effect.");
                    return;
                }
                Expression changer = (Expression)ReflectionUtils.getFieldValue(EffChange.class, "changer", change);
                Changer.ChangeMode mode = (Changer.ChangeMode)ReflectionUtils.getFieldValue(EffChange.class, "mode", change);
                if (changer instanceof IAsyncGettableExpression) {
                    delta = ((IAsyncGettableExpression)changer).getArrayAsync(event, changer);
                } else {
                    Object[] objectArray = delta = changer == null ? null : changer.getArray(event);
                }
                if (changed instanceof IAsyncChangeableExpression) {
                    IAsyncChangeableExpression asyncChangeable = (IAsyncChangeableExpression)changed;
                    Object[] objectArray = delta = changer == null ? delta : changer.beforeChange(changed, delta);
                    if ((delta == null || delta.length == 0) && mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) {
                        if (mode == Changer.ChangeMode.SET && changed.acceptChange(Changer.ChangeMode.DELETE) != null) {
                            asyncChangeable.changeAsync(event, null, Changer.ChangeMode.DELETE);
                        }
                        return;
                    }
                    asyncChangeable.changeAsync(event, delta, mode);
                } else {
                    changed.change(event, delta, mode);
                }
                return;
            }
            catch (Exception ex) {
                DiSky.getErrorHandler().exception(event, ex);
                return;
            }
        }
        this.effect.run(event);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "await " + this.effect.toString(event, debug);
    }

    static {
        Skript.registerEffect(AwaitEffect.class, (String[])new String[]{"await <.+>"});
    }
}

