/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.Debug;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Connect / Disconnect Bot")
@Description(value={"Connect or disconnect a bot to a specific audio channel (or disconnect it from the current one).", "The bot must have the required permissions to connect to the channel.", "If using the disconnect pattern, only the guild will be required."})
@Examples(value={"connect bot \"bot_name\" to voice channel with id \"000\"", "disconnect from event-guild"})
@Since(value={"4.9.0"})
public class ConnectBot
extends AsyncEffect {
    private Expression<Bot> exprBot;
    private boolean connect;
    private Expression<AudioChannel> exprAudioChannel;
    private Expression<Guild> exprGuild;

    public boolean init(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprBot = expressions[0];
        boolean bl = this.connect = i == 0;
        if (this.connect) {
            this.exprAudioChannel = expressions[1];
        } else {
            this.exprGuild = expressions[1];
        }
        return true;
    }

    public void execute(Event e) {
        AudioChannelUnion foundChannel;
        Bot bot = EasyElement.parseSingle(this.exprBot, e);
        Guild guild = EasyElement.parseSingle(this.exprGuild, e);
        AudioChannel channel = EasyElement.parseSingle(this.exprAudioChannel, e);
        if (EasyElement.anyNull((Object)this, bot)) {
            return;
        }
        if (this.connect && channel == null) {
            Debug.debug((Object)this, "Missing Channel", "You must specify a channel to connect to.");
            return;
        }
        if (!this.connect && guild == null) {
            Debug.debug((Object)this, "Missing Guild", "You must specify a guild to connect to.");
            return;
        }
        AudioChannel audioChannel = foundChannel = this.connect ? bot.getInstance().getChannelById(AudioChannel.class, channel.getId()) : guild.getAudioManager().getConnectedChannel();
        if (foundChannel == null) {
            Skript.error((String)("The audio channel with id " + channel.getId() + " is not found for bot " + bot.getName() + "!"));
            return;
        }
        if (this.connect) {
            foundChannel.getGuild().getAudioManager().openAudioConnection(foundChannel);
        } else {
            foundChannel.getGuild().getAudioManager().closeAudioConnection();
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return this.connect ? "connect " + this.exprBot.toString(e, debug) + " to " + this.exprAudioChannel.toString(e, debug) : "disconnect " + this.exprBot.toString(e, debug) + " from " + this.exprGuild.toString(e, debug);
    }

    static {
        Skript.registerEffect(ConnectBot.class, (String[])new String[]{"connect %bot% to [the] [(audio|voice)] [channel] %audiochannel%", "disconnect [[the] [bot] %bot%] from [the] [guild] %guild%"});
    }
}

