/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.JDAUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Create Emote")
@Description(value={"Create a new emote in a specific guild.", "The name must be between 2 and 32 chars and the guild should not have an emote with the same name.", "The URL will represent the image, and can be either a web URL or a local path."})
@Examples(value={"create new emote named \"test\" with url \"https://static.wikia.nocookie.net/leagueoflegends/images/a/ae/This_Changes_Everything_Emote.png/revision/latest/scale-to-width-down/250?cb=20211019231749\" in event-guild and store it in {_emote}", "make emote with name \"test2\" with path \"plugins/path/image.png\" in event-guild and store it in {_emote}"})
public class CreateEmote
extends AsyncEffect {
    private Expression<String> exprName;
    private Expression<String> exprURL;
    private Expression<Guild> exprGuild;
    private Expression<Object> exprResult;

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "create new emote named " + this.exprName.toString(e, debug) + " with url/path " + this.exprURL.toString(e, debug) + " in guild " + this.exprGuild.toString(e, debug) + " and store it in " + this.exprResult.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprName = exprs[0];
        this.exprURL = exprs[1];
        this.exprGuild = exprs[2];
        this.exprResult = exprs[3];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Emote.class});
    }

    public void execute(@NotNull Event e) {
        Emote emote;
        String name = (String)this.exprName.getSingle(e);
        String url = (String)this.exprURL.getSingle(e);
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (EasyElement.anyNull((Object)this, name, guild, url)) {
            return;
        }
        Icon icon = JDAUtils.parseIcon(url);
        if (EasyElement.anyNull((Object)this, icon)) {
            return;
        }
        try {
            emote = Emote.fromJDA((CustomEmoji)guild.createEmoji(name, icon, new Role[0]).complete());
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
            return;
        }
        this.exprResult.change(e, (Object[])new Emote[]{emote}, Changer.ChangeMode.SET);
    }

    static {
        Skript.registerEffect(CreateEmote.class, (String[])new String[]{"(make|create) [the] [new] emote (named|with name) %string% with [the] (url|path) %string% in [the] [guild] %guild% and store (it|the emote) in %~objects%"});
    }
}

