/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.skript.util.Date;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.SkriptUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Create Scheduled Event")
@Description(value={"Create a new scheduled event in a specific channel or at a specific place.", "If you use the second pattern (without channel), you'll have to specify the guild where the event will be created, and a start & end date.", "If you use the first pattern (with channel), you'll just have to specific the channel itself and a start date.", "Scheduled events currently only support stage & voice channels."})
@Examples(value={"create scheduled event named \"Let's Talk Together\" in stage channel with id \"000\" at (5 hours after now) and store it in {_event}", "create scheduled event named \"Concerto\" at \"6 routes of XXX\" starting (1 hour after now) and ending (5 hours after now) in event-guild and store it in {_event}"})
public class CreateScheduledEvent
extends AsyncEffect {
    private Expression<String> exprName;
    private Expression<GuildChannel> exprChannel;
    private Expression<Date> exprDate;
    private Expression<String> exprPlace;
    private Expression<Date> exprStart;
    private Expression<Date> exprEnd;
    private Expression<Guild> exprGuild;
    private Expression<Object> exprResult;
    private boolean isPlace = false;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.isPlace = i == 1;
        this.exprName = expressions[0];
        if (this.isPlace) {
            this.exprPlace = expressions[1];
            this.exprStart = expressions[2];
            this.exprEnd = expressions[3];
            this.exprGuild = expressions[4];
            this.exprResult = expressions[5];
        } else {
            this.exprChannel = expressions[1];
            this.exprDate = expressions[2];
            this.exprResult = expressions[3];
        }
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{ScheduledEvent.class});
    }

    public void execute(@NotNull Event e) {
        ScheduledEvent event;
        String name = EasyElement.parseSingle(this.exprName, e);
        if (EasyElement.anyNull((Object)this, name)) {
            return;
        }
        if (this.isPlace) {
            Guild guild;
            Date end;
            Date start;
            String place = EasyElement.parseSingle(this.exprPlace, e);
            if (EasyElement.anyNull((Object)this, place, start = EasyElement.parseSingle(this.exprStart, e), end = EasyElement.parseSingle(this.exprEnd, e), guild = EasyElement.parseSingle(this.exprGuild, e))) {
                return;
            }
            try {
                event = (ScheduledEvent)guild.createScheduledEvent(name, place, SkriptUtils.convertDate(start), SkriptUtils.convertDate(end)).complete();
            }
            catch (Exception ex) {
                DiSky.getErrorHandler().exception(e, ex);
                return;
            }
        }
        GuildChannel channel = EasyElement.parseSingle(this.exprChannel, e);
        Date date = EasyElement.parseSingle(this.exprDate, e);
        if (channel == null || date == null) {
            return;
        }
        try {
            event = (ScheduledEvent)channel.getGuild().createScheduledEvent(name, channel, SkriptUtils.convertDate(date)).complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
            return;
        }
        this.exprResult.change(e, (Object[])new ScheduledEvent[]{event}, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        if (this.isPlace) {
            return "create scheduled event named " + this.exprName.toString(e, debug) + " at " + this.exprPlace.toString(e, debug) + " starting at " + this.exprStart.toString(e, debug) + " and ending at " + this.exprEnd.toString(e, debug) + " in " + this.exprGuild.toString(e, debug);
        }
        return "create scheduled event named " + this.exprName.toString(e, debug) + " in " + this.exprChannel.toString(e, debug) + " at " + this.exprDate.toString(e, debug);
    }

    static {
        Skript.registerEffect(CreateScheduledEvent.class, (String[])new String[]{"create [a] [new] scheduled event (with name|named) %string% in %guildchannel% at %date% and store (it|the event) in %~objects%", "create [a] [new] scheduled event (with name|named) %string% at %string% starting [at] %date% [and] ending [at] %date% in %guild% and store (it|the event) in %~objects%"});
    }
}

