/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import java.util.Set;
import net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.specific.InteractionEvent;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Defer Interaction")
@Description(value={"Only usable in interaction event, currently button click/dropdown update/modal event!", "This will force the interaction to be acknowledge, you have 3 seconds to do so, the effect will send a success message to Discord or hold the interaction to send a message later.", "Keep in mind that replying in an interaction event will automatically defer the interaction, and therefore you don't need to defer it.", "If you need to wait more than 3 seconds use the and wait pattern", "An interaction can only be deferred once!"})
@Examples(value={"defer the interaction", "defer the interaction and wait", "defer the interaction and wait silently"})
public class DeferInteraction
extends AsyncEffect {
    public static final Set<Long> WAITING_INTERACTIONS = new HashSet<Long>();
    private boolean isEphemeral;
    private boolean shouldwait;

    public boolean init(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        if (!EasyElement.containsInterfaces(InteractionEvent.class)) {
            Skript.error((String)"The defer interaction effect can only be used in interaction events!");
            return false;
        }
        this.isEphemeral = parseResult.mark == 1;
        this.shouldwait = parseResult.expr.contains("and wait");
        return true;
    }

    public void execute(Event e) {
        GenericInteractionCreateEvent event = ((InteractionEvent)e).getInteractionEvent();
        try {
            if (this.shouldwait) {
                ((IReplyCallback)((Object)event)).deferReply(this.isEphemeral).complete();
                WAITING_INTERACTIONS.add(event.getInteraction().getIdLong());
            } else {
                if (event instanceof GenericComponentInteractionCreateEvent) {
                    ((ComponentInteraction)((Object)event)).deferEdit().complete();
                }
                if (event instanceof ModalInteractionEvent) {
                    ((ModalInteractionEvent)event).deferEdit().complete();
                }
            }
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "defer the interaction";
    }

    static {
        Skript.registerEffect(DeferInteraction.class, (String[])new String[]{"(acknowledge|defer) [the] interaction [and wait [(1\u00a6silently)]]"});
    }
}

