/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.events.specific.InteractionEvent;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import net.itsthesky.disky.managers.wrappers.RegisteredWebhook;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Destroy Discord Entity")
@Description(value={"Destroy on Discord the wanted entity."})
@Examples(value={"destroy event-channel", "destroy event-message"})
public class DestroyEntity
extends AsyncEffect {
    private Expression<Object> exprEntity;
    private Node node;

    public boolean init(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.node = this.getParser().getNode();
        this.exprEntity = expressions[0];
        return true;
    }

    public void execute(Event e) {
        RestAction<Void> action;
        Object entity = EasyElement.parseSingle(this.exprEntity, e, null);
        if (EasyElement.anyNull((Object)this, entity)) {
            return;
        }
        if (entity instanceof Message) {
            Message message2 = entity;
            @Nullable RegisteredWebhook webhook = DiSky.getWebhooksManager().getWebhookById(message2.getAuthor().getId());
            if (webhook != null) {
                DiSky.debug("Deleting message with webhook");
                action = webhook.getClient().deleteMessageById(message2.getId());
            } else {
                DiSky.debug("Deleting message without webhook");
                action = message2.delete();
            }
        } else {
            action = entity instanceof Guild ? ((Guild)entity).delete() : (entity instanceof Role ? ((Role)entity).delete() : (entity instanceof Channel ? ((Channel)entity).delete() : (entity instanceof Emote && ((Emote)entity).isCustom() ? ((Emote)entity).getEmote().delete() : (entity instanceof Webhook ? ((Webhook)entity).delete() : null))));
        }
        if (EasyElement.anyNull((Object)this, action)) {
            return;
        }
        try {
            action.complete();
        }
        catch (Exception ex) {
            if (e instanceof InteractionEvent && entity instanceof Message && ex instanceof IllegalStateException) {
                DiSkyRuntimeHandler.error(new Exception("When deleting a message in an interaction, you must first DEFER the interaction!"), this.node);
                return;
            }
            DiSkyRuntimeHandler.error(ex, this.node);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "destroy " + this.exprEntity.toString(e, debug);
    }

    static {
        Skript.registerEffect(DestroyEntity.class, (String[])new String[]{"destroy %guild/message/role/channel/emote/webhook%"});
    }
}

