/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Move Member")
@Description(value={"Move a member to another voice chat.", "You can only move a member if they were previously in a voice channel."})
@Examples(value={"move event-member to {_voice}"})
public class MoveMember
extends AsyncEffect {
    private Expression<Member> exprMember;
    private Expression<VoiceChannel> exprVoiceChannel;
    private boolean isDisconnect = false;

    public boolean init(Expression[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.isDisconnect = i == 1;
        this.exprMember = exprs[0];
        if (!this.isDisconnect) {
            this.exprVoiceChannel = exprs[1];
        }
        return true;
    }

    public void execute(@NotNull Event e) {
        Member member = EasyElement.parseSingle(this.exprMember, e, null);
        VoiceChannel voice = EasyElement.parseSingle(this.exprVoiceChannel, e, null);
        if (member == null) {
            return;
        }
        try {
            member.getGuild().moveVoiceMember(member, voice).complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "move " + this.exprMember.toString(e, debug) + " to channel " + this.exprVoiceChannel.toString(e, debug);
    }

    static {
        Skript.registerEffect(MoveMember.class, (String[])new String[]{"[voice] move [the] discord [member] %member% to [a] [voice[( |-)channel]] %voicechannel%", "[voice] disconnect [the] discord [member] %member%"});
    }
}

