/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.requests.restaction.order.RoleOrderAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Move Role Above/Under Role")
@Description(value={"Move a specific role above or under another role within the same guild.", "The indexes will be updated automatically."})
@Examples(value={"move role {_role} above role with id \"000\""})
public class MoveRole
extends AsyncEffect {
    private Expression<Role> exprTarget;
    private Expression<Role> exprRole;
    private Expression<Number> exprMod;
    private MoveType moveType;
    private Node node;

    public boolean init(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.node = this.getParser().getNode();
        this.exprTarget = expressions[0];
        this.moveType = MoveType.values()[i];
        if (this.moveType == MoveType.ABOVE || this.moveType == MoveType.UNDER) {
            this.exprRole = expressions[1];
        } else {
            this.exprMod = expressions[1];
        }
        return true;
    }

    public void execute(@NotNull Event e) {
        Role target = EasyElement.parseSingle(this.exprTarget, e);
        @Nullable Role role = EasyElement.parseSingle(this.exprRole, e);
        Number mod = EasyElement.parseSingle(this.exprMod, e, 1);
        if (target == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprTarget);
            return;
        }
        if (role == null && (this.moveType == MoveType.ABOVE || this.moveType == MoveType.UNDER)) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprRole);
            return;
        }
        if (target.getGuild().getIdLong() != role.getGuild().getIdLong()) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The specified roles are not in the same guild! (first is from '" + target.getGuild().getName() + "' and the second is from '" + role.getGuild().getName() + "')"), this.node);
            return;
        }
        if (mod.intValue() < 1) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The modifier must be at least 1! Got: " + String.valueOf(mod)), this.node);
            return;
        }
        if (this.moveType == MoveType.ABOVE) {
            DiSky.debug("Moving role " + role.getName() + " above " + target.getName());
        }
        RoleOrderAction action = target.getGuild().modifyRolePositions();
        action = switch (this.moveType) {
            default -> throw new IncompatibleClassChangeError();
            case MoveType.ABOVE, MoveType.UNDER -> (RoleOrderAction)action.selectPosition(role);
            case MoveType.UP, MoveType.DOWN -> (RoleOrderAction)action.selectPosition(target);
        };
        action = switch (this.moveType) {
            default -> throw new IncompatibleClassChangeError();
            case MoveType.ABOVE -> (RoleOrderAction)action.moveAbove(role);
            case MoveType.UNDER -> (RoleOrderAction)action.moveBelow(role);
            case MoveType.UP -> (RoleOrderAction)action.moveUp(mod.intValue());
            case MoveType.DOWN -> (RoleOrderAction)action.moveDown(mod.intValue());
        };
        try {
            action.complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        if (this.moveType == MoveType.ABOVE || this.moveType == MoveType.UNDER) {
            return "move role " + this.exprTarget.toString(e, debug) + " " + this.moveType.name().toLowerCase() + " " + this.exprRole.toString(e, debug);
        }
        return "move role " + this.exprTarget.toString(e, debug) + " " + this.moveType.name().toLowerCase() + " " + this.exprMod.toString(e, debug);
    }

    static {
        Skript.registerEffect(MoveRole.class, (String[])new String[]{"move [the] [discord] role %role% above [the] [discord] %role%", "move [the] [discord] role %role% under [the] [discord] %role%", "move [the] [discord] role %role% up [%-number% time[s]]", "move [the] [discord] role %role% down [%-number% time[s]]"});
    }

    public static enum MoveType {
        ABOVE,
        UNDER,
        UP,
        DOWN;

    }
}

