/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Mute Member")
@Description(value={"Mute or unmute a member in their guild."})
@Examples(value={"voice mute event-member", "unmute member event-member"})
public class MuteMember
extends AsyncEffect {
    private Expression<Member> exprMember;
    private int matchedPattern;

    public boolean init(Expression[] expr, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprMember = expr[0];
        this.matchedPattern = matchedPattern;
        return true;
    }

    public void execute(@NotNull Event e) {
        Member member = EasyElement.parseSingle(this.exprMember, e, null);
        if (member == null) {
            return;
        }
        try {
            member.mute(this.pattern2bool(this.matchedPattern)).complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "mute " + this.exprMember.toString(e, debug);
    }

    private boolean pattern2bool(int v) {
        return v <= 0;
    }

    static {
        Skript.registerEffect(MuteMember.class, (String[])new String[]{"[voice] mute [the] [discord] [member] %member%", "[voice] un[ |-]mute [the] [discord] [member] %member%"});
    }
}

