/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.SkriptUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PinMessage
extends AsyncEffect {
    private Node node;
    private boolean unpin;
    private Expression<Message> exprMessage;

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.node = this.getParser().getNode();
        this.exprMessage = expressions[0];
        this.unpin = parseResult.hasTag("un");
        return true;
    }

    protected void execute(@NotNull Event event) {
        RestAction<Void> action;
        Message message2 = (Message)this.exprMessage.getSingle(event);
        if (message2 == null) {
            return;
        }
        if (this.unpin) {
            if (!message2.isPinned()) {
                SkriptUtils.error(this.node, "Cannot unpin a message which is not pinned!");
                return;
            }
            action = message2.unpin();
        } else {
            if (message2.isPinned()) {
                SkriptUtils.error(this.node, "Cannot pin a message which is already pinned!");
                return;
            }
            action = message2.pin();
        }
        try {
            action.complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(event, ex);
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (this.unpin ? "un" : "") + "pin message " + this.exprMessage.toString(event, debug);
    }

    static {
        Skript.registerEffect(PinMessage.class, (String[])new String[]{"[:un]pin [the] [message] %message%"});
    }
}

