/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.SimpleDiSkyEvent;
import net.itsthesky.disky.api.skript.WaiterEffect;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetrieveEventValue
extends WaiterEffect<Object> {
    public static final HashMap<Class<? extends SimpleDiSkyEvent>, List<RetrieveValueInfo>> VALUES = new HashMap();
    private RetrieveValueInfo<Object, ?, Object> valueInfo;
    private String id;

    @Override
    public boolean initEffect(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        String rawId;
        try {
            rawId = (String)exprs[0].getSingle(null);
        }
        catch (Exception ex) {
            Skript.error((String)"The provided event-value string MUST be a literal / constant, aka not a variable or a changeable value.");
            return false;
        }
        Class eventClass = ParserInstance.get().getCurrentEvents()[0];
        List valuesInfo = VALUES.getOrDefault(eventClass, new ArrayList());
        @Nullable RetrieveValueInfo valueInfo = valuesInfo.stream().filter(value -> value.getCodeName().equalsIgnoreCase(rawId)).findAny().orElse(null);
        if (valueInfo == null) {
            Skript.error((String)("Unknown event-value '" + rawId + "' for event '" + ParserInstance.get().getCurrentEventName() + "'. Found the following values: " + (valuesInfo.isEmpty() ? "none" : valuesInfo.stream().map(RetrieveValueInfo::getCodeName).collect(Collectors.joining(", ")))));
            return false;
        }
        this.valueInfo = valueInfo;
        this.id = rawId;
        return this.validateVariable(exprs[1], false, true);
    }

    @Override
    public void runEffect(Event e) {
        SimpleDiSkyEvent event = (SimpleDiSkyEvent)e;
        this.valueInfo.getAction().apply((Object)event).queue(entity -> this.restart(this.valueInfo.getConverter().apply(entity)), ex -> {
            this.restart();
            DiSky.getErrorHandler().exception(e, (Throwable)ex);
        });
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "retrieve event-value " + this.id + " and store it in " + this.variableAsString(e, debug);
    }

    static {
        Skript.registerEffect(RetrieveEventValue.class, (String[])new String[]{"retrieve [the] [event[(-| )]]value %string% and store (it|the value) in %objects%"});
    }

    public static class RetrieveValueInfo<B, T, S> {
        private final Class<B> clazz;
        private final String codeName;
        private final Function<B, RestAction<T>> action;
        private final Function<S, T> converter;

        public RetrieveValueInfo(Class<B> clazz, String codeName, Function<B, RestAction<T>> action, Function<S, T> converter) {
            this.clazz = clazz;
            this.codeName = codeName;
            this.action = action;
            this.converter = converter;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public Class<B> getClazz() {
            return this.clazz;
        }

        public Function<B, RestAction<T>> getAction() {
            return this.action;
        }

        public Function<S, T> getConverter() {
            return this.converter;
        }
    }
}

