/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Send typing")
@Description(value={"Sends the typing status to discord. This is what is used to make the message \"X is typing...\" appear.", "Typing status lasts for 10 seconds."})
@Examples(value={"show typing status in event-channel"})
public class SendTyping
extends AsyncEffect {
    private Expression<Channel> exprChannel;
    private Node node;

    public boolean init(Expression[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        this.exprChannel = expr[0];
        return true;
    }

    public void execute(@NotNull Event e) {
        Channel channel = EasyElement.parseSingle(this.exprChannel, e, null);
        if (channel == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprChannel);
            return;
        }
        if (!channel.getType().isMessage()) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The given channel is a '" + channel.getType().name() + "' channel, not a message channel."), this.node, false);
        }
        MessageChannel msgChannel = (MessageChannel)channel;
        msgChannel.sendTyping().complete();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "send typing to " + this.exprChannel.toString(e, debug);
    }

    static {
        Skript.registerEffect(SendTyping.class, (String[])new String[]{"[discord] (send|show) typing [status] (in|to) [[text[ |-]]channel] %channel%"});
    }
}

