/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.itsthesky.disky.api.skript.WaiterEffect;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Shutdown Bot")
@Description(value={"Stop and disconnect a loaded bot from DiSky & discord.", "If any requests was still remaining, they will be executed before the actual bot shutdown", "Using the force pattern will cancel all requests and shutdown the bot instantly."})
@Examples(value={"shutdown bot named \"name\"", "stop bot \"name\""})
public class StopBot
extends WaiterEffect {
    private Expression<Bot> exprBot;
    boolean force;

    public boolean initEffect(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.exprBot = expressions[0];
        this.force = parseResult.expr.contains("force");
        return true;
    }

    @Override
    public void runEffect(Event e) {
        Bot bot = StopBot.parseSingle(this.exprBot, e, null);
        if (!StopBot.anyNull((Object)this, bot)) {
            bot.shutdown(this.force);
        }
        this.restart();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return (this.force ? "force " : "") + "shutdown bot " + this.exprBot.toString(e, debug);
    }

    static {
        Skript.registerEffect(StopBot.class, (String[])new String[]{"[force] (stop|shutdown) [the] [bot] %bot%"});
    }
}

