/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.LinkedList;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.skript.SpecificBotEffect;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Suppress Reaction")
@Description(value={"Suppress one or more reactions of a message.", "You can also specific the user who added the emote to remove it one time.", "Without any specified user, it will be the bot's self user that removes the emote."})
@Examples(value={"suppress reaction \"x\" of event-user from event-message", "suppress reaction \"joy\" from event-message # Remove the reaction ADDED BY THE BOT"})
@Since(value={"4.1.1"})
public class SuppressReaction
extends SpecificBotEffect {
    private Expression<Emote> exprEmote;
    private Expression<User> exprUser;
    private Expression<Message> exprMessage;

    @Override
    public boolean initEffect(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.exprEmote = expressions[0];
        this.exprUser = expressions[1];
        this.exprMessage = expressions[2];
        return true;
    }

    @Override
    public void runEffect(@NotNull Event e, Bot bot) {
        Emote[] emotes = SuppressReaction.parseList(this.exprEmote, e, null);
        User user = SuppressReaction.parseSingle(this.exprUser, e, null);
        Message message2 = SuppressReaction.parseSingle(this.exprMessage, e, null);
        if (SuppressReaction.anyNull((Object)this, emotes, message2)) {
            this.restart();
            return;
        }
        LinkedList<RestAction<Void>> actions = new LinkedList<RestAction<Void>>();
        for (Emote emote : emotes) {
            if (user == null) {
                actions.add(message2.removeReaction(emote.getEmoji()));
                continue;
            }
            actions.add(message2.removeReaction(emote.getEmoji(), user));
        }
        RestAction.allOf(actions).queue(x$0 -> this.restart(x$0), ex -> {
            this.restart();
            DiSky.getErrorHandler().exception(this.event, (Throwable)ex);
        });
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "suppress reaction " + this.exprEmote.toString(e, debug) + (String)(this.exprUser != null ? " of " + this.exprUser.toString(e, debug) : "") + " from " + this.exprMessage.toString(e, debug);
    }

    static {
        Skript.registerEffect(SuppressReaction.class, (String[])new String[]{"suppress [the] %emotes% [(of|from) [the] %-user%] (of|from) [the] %message%"});
    }
}

