/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.time.Duration;
import java.time.Instant;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.SpecificBotEffect;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.Utils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TimeOut Member")
@Description(value={"Timeout a member (temporal exclusion) for a specific duration and with an optional reason.", "You can either timeout UNTIL a specific date (Skript date), or FOR a specific timespan (Skript timespan).", "This also can be used to remove the current time out, if the bot has the permission to do so."})
@Examples(value={"timeout event-member for 5 minutes due to \"ur so bad\"", "time out event-member until {_date}", "stop time out of event-member"})
public class TimeOutMember
extends SpecificBotEffect {
    private Expression<Member> exprMember;
    private Expression<Object> exprTime;
    private Expression<String> exprReason;
    private int matchedPattern;

    @Override
    public boolean initEffect(Expression[] expressions, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.matchedPattern = matchedPattern;
        this.exprMember = expressions[0];
        if (matchedPattern == 2) {
            return true;
        }
        this.exprTime = expressions[1];
        this.exprReason = expressions[2];
        return true;
    }

    @Override
    public void runEffect(@NotNull Event e, Bot bot) {
        Member member = TimeOutMember.parseSingle(this.exprMember, e, null);
        if (this.matchedPattern == 2 && !TimeOutMember.anyNull((Object)this, new Object[]{this, member})) {
            Utils.catchAction(member.removeTimeout(), v -> this.restart(), ex -> {
                DiSky.getErrorHandler().exception(e, (Throwable)ex);
                this.restart();
            });
            return;
        }
        Object entity = TimeOutMember.parseSingle(this.exprTime, e, null);
        @Nullable String reason = TimeOutMember.parseSingle(this.exprReason, e, null);
        if (TimeOutMember.anyNull((Object)this, new Object[]{this, member, entity})) {
            this.restart();
            return;
        }
        if (this.matchedPattern == 0) {
            Utils.catchAction(member.timeoutFor(Duration.ofMillis(((Timespan)entity).getAs(Timespan.TimePeriod.MILLISECOND))).reason(reason), v -> this.restart(), ex -> {
                DiSky.getErrorHandler().exception(e, (Throwable)ex);
                this.restart();
            });
        } else if (this.matchedPattern == 1) {
            Utils.catchAction(member.timeoutUntil(Instant.ofEpochMilli(((Date)entity).getTime())).reason(reason), v -> this.restart(), ex -> {
                DiSky.getErrorHandler().exception(e, (Throwable)ex);
                this.restart();
            });
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "time out " + this.exprMember.toString(e, debug) + " for/until " + this.exprTime.toString(e, debug);
    }

    static {
        Skript.registerEffect(TimeOutMember.class, (String[])new String[]{"time[( |-)]out %member% for %timespan% [(for [the reason]|due to) %-string%]", "time[( |-)]out %member% until %date% [(for [the reason]|due to) %-string%]", "(stop|remove) time[( |-)]out (from|of) %member%"});
    }
}

