/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.find;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.DiSky;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindMembersWithNickname
extends AsyncEffect {
    private Expression<String> exprNickname;
    private Expression<Guild> exprGuild;
    private Expression<Object> exprResult;
    private Node node;
    private boolean ignoreCase;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprNickname = expressions[0];
        this.exprGuild = expressions[1];
        this.exprResult = expressions[2];
        this.node = this.getParser().getNode();
        this.ignoreCase = parseResult.hasTag("case");
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member[].class});
    }

    protected void execute(@NotNull Event event) {
        List<Member> members;
        String nickname = (String)this.exprNickname.getSingle(event);
        Guild guild = (Guild)this.exprGuild.getSingle(event);
        if (nickname == null || guild == null) {
            return;
        }
        try {
            members = guild.findMembers(member -> {
                if (this.ignoreCase) {
                    return member.getEffectiveName().equalsIgnoreCase(nickname);
                }
                return member.getEffectiveName().equals(nickname);
            }).get();
        }
        catch (Exception e) {
            DiSky.getErrorHandler().exception(event, e);
            return;
        }
        this.exprResult.change(event, (Object[])members.toArray(new Member[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "find members with nickname " + this.exprNickname.toString(event, debug) + " in guild " + this.exprGuild.toString(event, debug) + " and store them in " + this.exprResult.toString(event, debug);
    }

    static {
        Skript.registerEffect(FindMembersWithNickname.class, (String[])new String[]{"find [the] [discord] member[s] with [the] nick[( |-)]name %string% [case:ignor(e|ing) [the] case] (from|in) [the] [guild] %guild% and store (them|the member[s]) in %~objects%"});
    }
}

