/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class RetrieveEmotes
extends AsyncEffect {
    private Expression<Guild> exprGuild;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprGuild = expressions[0];
        this.exprBot = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Emote[].class});
    }

    protected void execute(Event event) {
        List<RichCustomEmoji> emotes;
        Guild guild = (Guild)this.exprGuild.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (guild == null || bot == null) {
            return;
        }
        guild = bot.getInstance().getGuildById(guild.getId());
        if (guild == null) {
            return;
        }
        try {
            emotes = guild.retrieveEmojis().complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(event, ex);
            return;
        }
        this.exprResult.change(event, (Object[])emotes.stream().map(Emote::fromJDA).toArray(Emote[]::new), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "retrieve emotes from guild " + this.exprGuild.toString(e, debug) + (String)(this.exprBot != null ? " using bot " + this.exprBot.toString(e, debug) : "") + " and store them in " + this.exprResult.toString(e, debug);
    }

    static {
        Skript.registerEffect(RetrieveEmotes.class, (String[])new String[]{"retrieve [(all|every)] emotes (from|with|of|in) %guild% [(with|using) [the] [bot] %-bot%] and store (them|the emotes) in %~objects%"});
    }
}

