/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetrieveMember
extends AsyncEffect {
    private Expression<String> exprID;
    private Expression<Guild> exprGuild;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprID = expressions[0];
        this.exprGuild = expressions[1];
        this.exprBot = expressions[2];
        this.exprResult = expressions[3];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member.class});
    }

    protected void execute(@NotNull Event event) {
        Member member;
        String id = (String)this.exprID.getSingle(event);
        Guild guild = (Guild)this.exprGuild.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (id == null || guild == null || bot == null) {
            return;
        }
        guild = bot.getInstance().getGuildById(guild.getId());
        if (guild == null) {
            return;
        }
        try {
            member = (Member)guild.retrieveMemberById(id).complete();
        }
        catch (Exception ex) {
            return;
        }
        this.exprResult.change(event, (Object[])new Member[]{member}, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "retrieve member with id " + this.exprID.toString(event, b) + " from guild " + this.exprGuild.toString(event, b) + (String)(this.exprBot == null ? "" : " with bot " + this.exprBot.toString(event, b)) + " and store it in " + this.exprResult.toString(event, b);
    }

    static {
        Skript.registerEffect(RetrieveMember.class, (String[])new String[]{"retrieve [the] member (with|from) id %string% (from|with|of|in) %guild% [(with|using) [the] [bot] %-bot%] and store (it|the member) in %~objects%"});
    }
}

