/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.User;
import net.itsthesky.disky.DiSky;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Retrieve Profile")
@Description(value={"Retrieve the profile of the specified user.", "Profile represent mainly the banner of the user, could return the accent color if non set."})
public class RetrieveProfile
extends AsyncEffect {
    private Expression<String> exprID;
    private Expression<User> exprUser;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprID = expressions[0];
        this.exprUser = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{User.Profile.class});
    }

    protected void execute(@NotNull Event event) {
        User.Profile profile;
        String id = (String)this.exprID.getSingle(event);
        User user = (User)this.exprUser.getSingle(event);
        if (id == null || user == null) {
            return;
        }
        try {
            profile = (User.Profile)user.retrieveProfile().complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(event, ex);
            return;
        }
        this.exprResult.change(event, (Object[])new User.Profile[]{profile}, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "retrieve profile (with|from) id " + this.exprID.toString(event, b) + " (from|with|of|in) " + this.exprUser.toString(event, b) + " and store (it|the profile) in " + this.exprResult.toString(event, b);
    }

    static {
        Skript.registerEffect(RetrieveProfile.class, (String[])new String[]{"retrieve profile (with|from) id %string% (from|with|of|in) %user% and store (it|the profile) in %~object%"});
    }
}

