/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.sticker.GuildSticker;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Retrieve Stickers")
@Description(value={"Retrieve every stickers (and cache them) from a specific guild."})
public class RetrieveStickers
extends AsyncEffect {
    private Expression<Guild> exprGuild;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprGuild = expressions[0];
        this.exprBot = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{GuildSticker[].class});
    }

    protected void execute(@NotNull Event event) {
        List<GuildSticker> stickers;
        Guild guild = (Guild)this.exprGuild.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (guild == null || bot == null) {
            return;
        }
        guild = bot.getInstance().getGuildById(guild.getId());
        if (guild == null) {
            return;
        }
        try {
            stickers = guild.retrieveStickers().complete();
        }
        catch (Exception ex) {
            Skript.error((String)("Cannot retrieve stickers from the guild " + guild.getName() + " (" + guild.getId() + ")"));
            return;
        }
        this.exprResult.change(event, (Object[])stickers.toArray(new GuildSticker[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "retrieve every stickers from guild " + this.exprGuild.toString(event, b) + (String)(this.exprBot == null ? "" : " using bot " + this.exprBot.toString(event, b)) + " and store them in " + this.exprResult.toString(event, b);
    }

    static {
        Skript.registerEffect(RetrieveStickers.class, (String[])new String[]{"retrieve [(all|every)] stickers (from|with|of|in) %guild% [(with|using) [the] [bot] %-bot%] and store (them|the stickers) in %~objects%"});
    }
}

