/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.ThreadMember;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Retrieve Thread Members")
@Description(value={"Retrieve every members (and cache them) from a specific thread."})
public class RetrieveThreadMembers
extends AsyncEffect {
    private Expression<ThreadChannel> exprChannel;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprChannel = expressions[0];
        this.exprBot = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member[].class});
    }

    protected void execute(@NotNull Event event) {
        List members;
        ThreadChannel channel = (ThreadChannel)this.exprChannel.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (channel == null || bot == null) {
            return;
        }
        channel = bot.getInstance().getThreadChannelById(channel.getId());
        if (channel == null) {
            return;
        }
        try {
            members = (List)channel.retrieveThreadMembers().complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(event, ex);
            return;
        }
        this.exprResult.change(event, members.stream().map(ThreadMember::getMember).toArray(), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "retrieve thread members from " + this.exprChannel.toString(event, b) + (String)(this.exprBot == null ? "" : " using " + this.exprBot.toString(event, b)) + " and store them in " + this.exprResult.toString(event, b);
    }

    static {
        Skript.registerEffect(RetrieveThreadMembers.class, (String[])new String[]{"retrieve [(all|every)] thread members (from|with|of|in) %threadchannel% [(with|using) [the] [bot] %-bot%] and store (them|the thread members) in %~objects%"});
    }
}

