/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.attribute.IPostContainer;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Retrieve Threads")
@Description(value={"Retrieve every threads (and cache them) from a specific guild.", "This effect will only get back the ACTIVE thread, and will pass on the archived ones."})
public class RetrieveThreads
extends AsyncEffect {
    private Expression<Object> exprGuild;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprGuild = expressions[0];
        this.exprBot = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{ThreadChannel[].class});
    }

    protected void execute(@NotNull Event event) {
        List<Object> threads;
        Object entity = this.exprGuild.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (bot == null || !(entity instanceof IPostContainer)) {
            return;
        }
        try {
            threads = entity instanceof Guild ? ((Guild)entity).retrieveActiveThreads().complete() : (entity instanceof ForumChannel ? (List<Object>)((ForumChannel)entity).retrieveArchivedPublicThreadChannels().complete() : new ArrayList<ThreadChannel>());
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(event, ex);
            return;
        }
        this.exprResult.change(event, (Object[])threads.toArray(new ThreadChannel[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "retrieve threads from guild " + this.exprGuild.toString(event, b) + (String)(this.exprBot == null ? "" : " using bot " + this.exprBot.toString(event, b)) + " and store them in " + this.exprResult.toString(event, b);
    }

    static {
        Skript.registerEffect(RetrieveThreads.class, (String[])new String[]{"retrieve [(all|every)] thread[s] (from|with|of|in) %guild/channel% [(with|using) [the] [bot] %-bot%] and store (them|the thread[s]) in %~objects%"});
    }
}

