/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.webhooks;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessagePollBuilder;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.managers.wrappers.RegisteredWebhook;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeClientSpeak
extends AsyncEffect {
    private Node node;
    private Expression<String> exprName;
    private Expression<Object> exprMessage;
    private Expression<String> exprAvatar;
    private Expression<String> exprUsername;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = expressions[0];
        this.exprMessage = expressions[1];
        this.exprUsername = expressions[2];
        this.exprAvatar = expressions[3];
        this.exprResult = expressions[4];
        this.node = this.getParser().getNode();
        return this.exprResult == null || Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Message.class});
    }

    protected void execute(@NotNull Event event) {
        Message resultMessage;
        String username;
        String name = (String)this.exprName.getSingle(event);
        Object message2 = this.exprMessage.getSingle(event);
        String avatar = this.exprAvatar == null ? null : (String)this.exprAvatar.getSingle(event);
        String string = username = this.exprUsername == null ? null : (String)this.exprUsername.getSingle(event);
        if (name == null || message2 == null) {
            return;
        }
        if (!DiSky.getWebhooksManager().isWebhookRegistered(name)) {
            SkriptUtils.error(this.node, "The webhook client named " + name + " isn't registered!");
            return;
        }
        MessageCreateBuilder builder = message2 instanceof MessageCreateBuilder ? (MessageCreateBuilder)message2 : (message2 instanceof EmbedBuilder ? (MessageCreateBuilder)new MessageCreateBuilder().addEmbeds(((EmbedBuilder)message2).build()) : (message2 instanceof MessagePollBuilder ? new MessageCreateBuilder().setPoll(((MessagePollBuilder)message2).build()) : (MessageCreateBuilder)new MessageCreateBuilder().setContent((String)message2)));
        RegisteredWebhook registerClient = DiSky.getWebhooksManager().getWebhook(name);
        WebhookClient<Message> client = registerClient.getClient();
        try {
            resultMessage = (Message)client.sendMessage(builder.build()).setUsername(username).setAvatarUrl(avatar).complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(event, ex);
            return;
        }
        if (this.exprResult == null) {
            return;
        }
        this.exprResult.change(event, (Object[])new Message[]{resultMessage}, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "make client " + this.exprName.toString(event, debug) + " send message " + this.exprMessage.toString(event, debug) + (String)(this.exprAvatar == null ? "" : " with avatar " + this.exprAvatar.toString(event, debug)) + (String)(this.exprUsername == null ? "" : " with username " + this.exprUsername.toString(event, debug)) + (String)(this.exprResult == null ? "" : " and store it in " + this.exprResult.toString(event, debug));
    }

    static {
        Skript.registerEffect(MakeClientSpeak.class, (String[])new String[]{"make [the] [webhook] client %string% (post|send) [the] [message] %string/messagecreatebuilder/embedbuilder/messagepollbuilder% [with [the] username %-string%] [[and] [with] [the] avatar [url] %-string%] [and store (it|the message) in %-~objects%]"});
    }
}

