/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.webhooks;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisterClient
extends Effect {
    private Node node;
    private Expression<Bot> exprBot;
    private Expression<String> exprName;
    private Expression<String> exprURL;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprBot = expressions[0];
        this.exprName = expressions[1];
        this.exprURL = expressions[2];
        this.node = this.getParser().getNode();
        return true;
    }

    protected void execute(@NotNull Event event) {
        Bot bot = (Bot)this.exprBot.getSingle(event);
        String name = (String)this.exprName.getSingle(event);
        String url = (String)this.exprURL.getSingle(event);
        if (bot == null || name == null || url == null) {
            return;
        }
        if (DiSky.getWebhooksManager().isWebhookRegistered(name)) {
            SkriptUtils.error(this.node, "The webhook client named " + name + " is already registered!");
            return;
        }
        DiSky.getWebhooksManager().registerWebhook(bot, name, url);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "register a new webhook client in bot " + this.exprBot.toString(event, debug) + " with name " + this.exprName.toString(event, debug) + " and url " + this.exprURL.toString(event, debug);
    }

    static {
        Skript.registerEffect(RegisterClient.class, (String[])new String[]{"register [a] [new] webhook[s] [client] (in|using) [the] [bot] %bot% (with [the] name|named) %string% (and|with) [the] [webhook] url %string%"});
    }
}

