/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.webhooks;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.attribute.IWebhookContainer;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetrieveWebhooks
extends AsyncEffect {
    private Expression<Channel> exprChannel;
    private Expression<Object> exprVar;
    private Node node;

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprChannel = expressions[0];
        this.exprVar = expressions[1];
        this.node = this.getParser().getNode();
        return Changer.ChangerUtils.acceptsChange(this.exprVar, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Webhook.class});
    }

    protected void execute(@NotNull Event event) {
        Channel target = (Channel)this.exprChannel.getSingle(event);
        Object var = this.exprVar.getSingle(event);
        if (target == null || var == null) {
            return;
        }
        if (!(target instanceof IWebhookContainer) && !(target instanceof Guild)) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The entity " + String.valueOf(target) + " is not a webhook container (= text channel) or guild!"), this.node);
            return;
        }
        try {
            List<Webhook> webhooks = target instanceof IWebhookContainer ? ((IWebhookContainer)target).retrieveWebhooks().complete() : ((Guild)((Object)target)).retrieveWebhooks().complete();
            this.exprVar.change(event, (Object[])webhooks.toArray(new Webhook[0]), Changer.ChangeMode.SET);
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
            this.exprVar.change(event, (Object[])new Webhook[0], Changer.ChangeMode.SET);
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "retrieve webhooks from entity " + this.exprChannel.toString(event, debug) + " and store them in " + this.exprVar.toString(event, debug);
    }

    static {
        Skript.registerEffect(RetrieveWebhooks.class, (String[])new String[]{"retrieve [the] webhook[s] (from|of) [the] [channel] %channel/textchannel/guild% and store (them|the webhook[s]) in %objects%"});
    }
}

