/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.events.rework;

import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.events.guild.GenericGuildEvent;
import net.dv8tion.jda.api.events.guild.update.GenericGuildUpdateEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateAfkChannelEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateAfkTimeoutEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateBannerEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateBoostCountEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateBoostTierEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateIconEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateNameEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateOwnerEvent;
import net.dv8tion.jda.api.events.guild.update.GuildUpdateSplashEvent;
import net.itsthesky.disky.api.events.rework.CopyEventCategory;
import net.itsthesky.disky.api.events.rework.EventRegistryFactory;
import net.itsthesky.disky.elements.events.rework.GuildEvents;

@CopyEventCategory(value=GuildEvents.class)
public class GuildUpdateEvents {
    static {
        EventRegistryFactory.builder(GuildUpdateAfkChannelEvent.class).name("Guild AFK Channel Event").patterns("[discord] guild afk channel (change|update)").description("Fired when the AFK channel of a guild changes. Can be used to get the old/new channel, the author and the guild.").example("on guild afk channel change:\n    broadcast \"Guild %event-guild% changed AFK channel from %past afk channel% to %current afk channel%\"").customTimedExpressions("afk channel", VoiceChannel.class, GenericGuildUpdateEvent::getNewValue, GenericGuildUpdateEvent::getOldValue).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateAfkTimeoutEvent.class).name("Guild AFK Timeout Event").patterns("[discord] guild afk timeout (change|update)").description("Fired when the AFK timeout of a guild changes. Can be used to get the old/new timeout value, the author and the guild.").example("on guild afk timeout change:\n    broadcast \"Guild %event-guild% changed AFK timeout from %past afk timeout% to %current afk timeout%\"").customTimedExpressions("afk timeout", Guild.Timeout.class, GuildUpdateAfkTimeoutEvent::getNewValue, GuildUpdateAfkTimeoutEvent::getOldValue).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateBannerEvent.class).name("Guild Banner Event").patterns("[discord] guild banner (change|update)").description("Fired when the banner of a guild changes. Can be used to get the old/new banner URL, the author and the guild.").example("on guild banner change:\n    broadcast \"Guild %event-guild% changed banner from %past banner% to %current banner%\"").customTimedExpressions("banner", String.class, GuildUpdateBannerEvent::getNewBannerUrl, GuildUpdateBannerEvent::getOldBannerUrl).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateBoostCountEvent.class).name("Guild Boost Count Update").patterns("[discord] guild boost count (change|update)").description("Fired when the boost count of a guild changes. Can be used to get the old/new count, and the guild.").example("on guild boost count change:\n    broadcast \"Guild %event-guild% boost count changed from %past boost count% to %current boost count%\"").customTimedExpressions("boost count", Integer.class, GuildUpdateBoostCountEvent::getNewValue, GuildUpdateBoostCountEvent::getOldValue).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateBoostTierEvent.class).name("Guild Boost Tier Update").patterns("[discord] guild boost tier (change|update)").description("Fired when the boost tier of a guild changes. Can be used to get the old/new tier, and the guild.").example("on guild boost tier change:\n    broadcast \"Guild %event-guild% boost tier changed from %past boost tier% to %current boost tier%\"").customTimedExpressions("boost tier", String.class, event -> event.getNewBoostTier().name(), event -> event.getOldBoostTier().name()).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateIconEvent.class).name("Guild Icon Event").patterns("[discord] guild icon (change|update)").description("Fired when the icon of a guild changes. Can be used to get the old/new icon URL, the author and the guild.").example("on guild icon change:\n    broadcast \"Guild %event-guild% changed icon from %past icon% to %current icon%\"").customTimedExpressions("icon", String.class, GuildUpdateIconEvent::getNewIconUrl, GuildUpdateIconEvent::getOldIconUrl).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateNameEvent.class).name("Guild Name Event").patterns("[discord] guild name (update|change)").description("Fired when the name of a guild is changed. Can be used to get the old/new name, the author and the guild.").example("on guild name change:\n    broadcast \"Guild name changed from '%past guild name%' to '%current guild name%'\"").customTimedExpressions("guild name", String.class, GuildUpdateNameEvent::getNewValue, GuildUpdateNameEvent::getOldValue).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateOwnerEvent.class).name("Guild Owner Event").patterns("[discord] guild owner (change|update)").description("Fired when the owner of a guild changes. Can be used to get the old/new owner, the author and the guild.").example("on guild owner change:\n    broadcast \"Guild %event-guild% owner changed from %past owner% to %current owner%\"").customTimedExpressions("owner", Member.class, GuildUpdateOwnerEvent::getNewOwner, GuildUpdateOwnerEvent::getOldOwner).value(Guild.class, GenericGuildEvent::getGuild).author(GenericGuildEvent::getGuild).register();
        EventRegistryFactory.builder(GuildUpdateSplashEvent.class).name("Guild Splash Event").patterns("[discord] guild splash (change|update)").description("Fired when the splash image of a guild changes. Can be used to get the old/new splash URL, the author and the guild.").example("on guild splash change:\n    broadcast \"Guild %event-guild% splash changed from %past splash% to %current splash%\"").customTimedExpressions("splash", String.class, GuildUpdateSplashEvent::getNewSplashUrl, GuildUpdateSplashEvent::getOldSplashUrl).value(Guild.class, GenericGuildEvent::getGuild, 0).author(GenericGuildEvent::getGuild).register();
    }
}

