/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.events.rework;

import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.GenericMessageEvent;
import net.dv8tion.jda.api.events.message.react.GenericMessageReactionEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveAllEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveEvent;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.events.rework.BuiltEvent;
import net.itsthesky.disky.api.events.rework.EventRegistryFactory;
import net.itsthesky.disky.elements.events.rework.MessageEvents;

public class ReactionEvents {
    public static final BuiltEvent<?> REACTION_ADD = EventRegistryFactory.builder(MessageReactionAddEvent.class).eventCategory(MessageEvents.class).name("Reaction Add").patterns("(reaction|emote)[s] add[ed]").description("Fired when a message, that can be seen by the bot, receive a reaction.", "This will be fired, by default, both guild & private messages, use the 'event is from guild' condition to avoid confusion.").implementMessage(GenericMessageEvent::getChannel).restValue("message", GenericMessageReactionEvent::retrieveMessage).channelValues(GenericMessageEvent::getChannel).value(Guild.class, GenericMessageEvent::getGuild).value(Member.class, GenericMessageReactionEvent::getMember).value(User.class, GenericMessageReactionEvent::getUser).value(Emote.class, event -> Emote.fromUnion(event.getEmoji())).value(MessageReaction.class, GenericMessageReactionEvent::getReaction).value(Long.TYPE, MessageReactionAddEvent::getMessageAuthorIdLong).register();

    static {
        EventRegistryFactory.builder(MessageReactionRemoveEvent.class).eventCategory(MessageEvents.class).name("Reaction Remove").patterns("(reaction|emote)[s] remove[d]").description("Fired when an user remove a reaction from a specific message.", "This will be fired, by default, both guild & private messages, use the 'event is from guild' condition to avoid confusion.").implementMessage(GenericMessageEvent::getChannel).restValue("message", GenericMessageReactionEvent::retrieveMessage).channelValues(GenericMessageEvent::getChannel).value(Guild.class, GenericMessageEvent::getGuild).value(Member.class, GenericMessageReactionEvent::getMember).value(User.class, GenericMessageReactionEvent::getUser).value(Emote.class, event -> Emote.fromUnion(event.getEmoji())).register();
        EventRegistryFactory.builder(MessageReactionRemoveAllEvent.class).eventCategory(MessageEvents.class).name("Reaction Remove All").patterns("(reaction|emote)[s] (remove[d] all|clear|reset)").description("Fired when an user remove every reactions from a message.", "This will be fired, by default, both guild & private messages, use the 'event is from guild' condition to avoid confusion.").implementMessage(GenericMessageEvent::getChannel).restValue("message", event -> event.getChannel().retrieveMessageById(event.getMessageId())).value(Guild.class, GenericMessageEvent::getGuild).channelValues(GenericMessageEvent::getChannel).author(event -> event.isFromGuild() ? event.getGuild() : null).register();
    }
}

