/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.changers.IAsyncGettableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGetterExpression<T>
extends SimpleExpression<T>
implements IAsyncGettableExpression<T> {
    protected Node node;
    protected Expression<String> exprId;
    protected Expression<Bot> exprBot;

    protected static <T> void register(Class clazz, Class type, String codeName) {
        BaseGetterExpression.register(clazz, type, codeName, "id", true);
    }

    protected static <T> void register(Class clazz, Class type, String codeName, String property, boolean allowBot) {
        Skript.registerExpression((Class)clazz, (Class)type, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{codeName + " (with|from) [the] " + property + " %string% " + (allowBot ? "[(with|using) [the] [bot] [(named|with name)] %-bot%]" : "")});
    }

    protected abstract T get(String var1, Bot var2);

    protected T getAsync(String id, Bot bot) {
        return this.get(id, bot);
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprId = exprs[0];
        this.exprBot = exprs[1];
        this.node = this.getParser().getNode();
        return true;
    }

    protected @Nullable T @NotNull [] get(@NotNull Event e) {
        String id = (String)this.exprId.getSingle(e);
        Bot bot = Bot.fromContext(this.exprBot, e);
        if (EasyElement.anyNull(this, id, bot)) {
            return new Object[0];
        }
        if (!SkriptUtils.validateSnowflake(id, this.node)) {
            return new Object[0];
        }
        return new Object[]{this.get(id, bot)};
    }

    public boolean isSingle() {
        return true;
    }

    protected boolean allowBot() {
        return true;
    }

    public abstract String getCodeName();

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return this.getCodeName() + " with id " + this.exprId.toString(e, debug) + (String)(this.exprBot != null ? "using the bot " + this.exprBot.toString(e, debug) : "");
    }

    @Override
    public T[] getAsync(Event e) {
        String id = (String)this.exprId.getSingle(e);
        Bot bot = Bot.fromContext(this.exprBot, e);
        if (EasyElement.anyNull(this, id, bot)) {
            return new Object[0];
        }
        if (!SkriptUtils.validateSnowflake(id, this.node)) {
            return new Object[0];
        }
        return new Object[]{this.getAsync(id, bot)};
    }
}

