/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.emoji.ApplicationEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.emojis.Emojis;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.elements.changers.IAsyncGettableExpression;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Emoji / Emote")
@Description(value={"Get an emoji or an emote from its name, ID or unicode.", "- An emoji is discord-side only, can be used everywhere, and don't have any attached guild.", "- An emote is guild-side only, have a custom long ID and are attached to a guild.", "It the specified reaction doesn't exist, DiSky will simply return null and say it in console.", "We highly recommend the specification of the guild when retrieving an emote, to avoid conflicts with other that potentially have the same name."})
@Examples(value={"reaction \"joy\"", "emoji \"sparkles\"", "emote \"disky\" in event-guild"})
public class ExprEmoji
extends SimpleExpression<Emote>
implements IAsyncGettableExpression<Emote> {
    private static final Pattern COMPLEX_CUSTOM;
    private static final Pattern SIMPLE_CUSTOM;
    private static final Pattern NAMED;
    private Node node;
    private Expression<String> name;
    private Expression<Guild> guild;

    protected Emote @NotNull [] get(@NotNull Event e) {
        return this.get(e, false);
    }

    public Emote[] getAsync(Event e) {
        return this.get(e, true);
    }

    public Emote[] get(@NotNull Event e, boolean async) {
        Guild guild;
        String[] emotes = (String[])this.name.getAll(e);
        Guild guild2 = guild = this.guild == null ? null : (Guild)this.guild.getSingle(e);
        if (emotes.length == 0) {
            return new Emote[0];
        }
        ArrayList<Emote> parsed = new ArrayList<Emote>();
        for (String input : emotes) {
            parsed.add(this.parse(guild, input, async));
        }
        return parsed.toArray(new Emote[0]);
    }

    public Emote parse(@Nullable Guild guild, String input, boolean async) {
        DiSky.debug("Parsing emoji: " + input);
        Matcher simpleCustom = SIMPLE_CUSTOM.matcher(input);
        Matcher complexCustom = COMPLEX_CUSTOM.matcher(input);
        if (simpleCustom.matches() || complexCustom.matches()) {
            String id;
            DiSky.debug("  - Emoji is simple/complex custom");
            String string = id = simpleCustom.matches() ? simpleCustom.group() : complexCustom.group(1);
            if (guild == null) {
                @Nullable RichCustomEmoji emoji = DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getEmojiById(id));
                if (emoji == null && !async) {
                    DiSkyRuntimeHandler.error(new IllegalArgumentException("Unable to find the emote with ID '" + id + "' in any loaded bot. If you want to get an id from a GUILD, then you must specify that guild."), this.node, false);
                    return null;
                }
                if (emoji == null) {
                    ApplicationEmoji retrievedEmoji = DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().retrieveApplicationEmojiById(id).complete());
                    if (retrievedEmoji == null) {
                        DiSkyRuntimeHandler.error(new IllegalArgumentException("The emote with ID '" + id + "' doesn't exist! (neither as unicode or shortcode)"), this.node, false);
                        return null;
                    }
                    return new Emote(retrievedEmoji);
                }
                return new Emote(emoji);
            }
            RichCustomEmoji emote = guild.getEmojiById(id);
            if (emote == null) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("The emote with ID '" + id + "' doesn't exist in the guild '" + guild.getName() + "'!"), this.node, false);
                return null;
            }
            return new Emote(emote);
        }
        Matcher named = NAMED.matcher(input);
        String name = named.matches() ? named.group(1) : input;
        if (guild == null) {
            net.itsthesky.disky.api.emojis.Emoji emoji = Emojis.ofShortcode(name);
            if (emoji == null) {
                net.itsthesky.disky.api.emojis.Emoji unicodeEmoji = Emojis.ofUnicode(name);
                if (unicodeEmoji == null) {
                    DiSkyRuntimeHandler.error(new IllegalArgumentException("The emoji '" + name + "' doesn't exist! (neither as unicode or shortcode)"), this.node, false);
                    return null;
                }
                return new Emote(Emoji.fromUnicode(unicodeEmoji.unicode()));
            }
            return new Emote(Emoji.fromUnicode(emoji.unicode()));
        }
        RichCustomEmoji emote = guild.getEmojisByName(name, true).stream().findFirst().orElse(null);
        if (emote == null) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The emote with name '" + name + "' doesn't exist in the guild '" + guild.getName() + "'! (neither as unicode or shortcode)"), this.node, false);
            return null;
        }
        return new Emote(emote);
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Emote> getReturnType() {
        return Emote.class;
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "emoji named " + this.name.toString(e, debug) + (String)(this.guild == null ? "" : " from " + this.guild.toString(e, debug));
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.guild = exprs[1];
        this.node = this.getParser().getNode();
        return true;
    }

    static {
        Skript.registerExpression(ExprEmoji.class, Emote.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(emoji|emote|reaction)[s] %strings% [(from|in) %-guild%]"});
        COMPLEX_CUSTOM = Pattern.compile("^(?:<a?:[a-zA-Z0-9_]+:)?([0-9]+)>?$");
        SIMPLE_CUSTOM = Pattern.compile("^[0-9]{5,}$");
        NAMED = Pattern.compile("^:([a-zA-Z0-9_]+):$");
    }
}

