/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.getters.BaseGetterExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Get Audio Channel")
@Description(value={"This is an utility expression.", "It will returns an Audio Channel out of the provided ID.", "It will returns either the voice or stage channel corresponding to the provided ID.", "This expression cannot be changed."})
@Examples(value={"audio channel with id \"000\""})
@Since(value={"4.0.0"})
public class GetAudioChannel
extends BaseGetterExpression<AudioChannel> {
    @Override
    protected AudioChannel get(String id, Bot bot) {
        VoiceChannel voice = bot.getInstance().getVoiceChannelById(id);
        return voice == null ? bot.getInstance().getStageChannelById(id) : voice;
    }

    @Override
    public String getCodeName() {
        return "audio channel";
    }

    @NotNull
    public Class<? extends AudioChannel> getReturnType() {
        return AudioChannel.class;
    }

    static {
        GetAudioChannel.register(GetAudioChannel.class, AudioChannel.class, "audio channel");
    }
}

