/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.automod.AutoModRule;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.elements.changers.IAsyncGettableExpression;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class GetAutoModRule
extends SimpleExpression<AutoModRule>
implements IAsyncGettableExpression<AutoModRule> {
    private Expression<String> exprId;
    private Expression<Guild> exprGuild;
    private Node node;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprId = expressions[0];
        this.exprGuild = expressions[1];
        this.node = this.getParser().getNode();
        return true;
    }

    protected AutoModRule @Nullable [] get(Event event) {
        DiSkyRuntimeHandler.validateAsync(false, this.node);
        return new AutoModRule[0];
    }

    public AutoModRule[] getAsync(Event e) {
        String id = (String)this.exprId.getSingle(e);
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (!DiSkyRuntimeHandler.checkSet(this.node, id, this.exprId, guild, this.exprGuild)) {
            return new AutoModRule[0];
        }
        DiSky.debug("Getting automod rule with ID " + id + " in guild " + String.valueOf(guild));
        return new AutoModRule[]{guild.retrieveAutoModRuleById(id).complete()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends AutoModRule> getReturnType() {
        return AutoModRule.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "discord automod rule with id " + this.exprId.toString(event, debug) + " in guild " + this.exprGuild.toString(event, debug);
    }

    static {
        Skript.registerExpression(GetAutoModRule.class, AutoModRule.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [discord] automod rule with id %string% (from|in) [the] [guild] %guild%"});
    }
}

