/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Get Bot / Bot Named X")
@Description(value={"Get a cached bot from DiSky using its unique name.", "If the desired bot does not exist or is not loaded yet, this expression will return none.", "This expression cannot be changed."})
@Examples(value={"get bot \"name\"", "bot named \"name\""})
public class GetBot
extends SimpleExpression<Bot> {
    private Expression<String> exprName;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        return true;
    }

    protected Bot @NotNull [] get(@NotNull Event e) {
        Bot[] botArray;
        String name = (String)this.exprName.getSingle(e);
        if (name == null) {
            return new Bot[0];
        }
        @Nullable Bot bot = DiSky.getManager().fromName(name);
        if (bot == null) {
            DiSky.getErrorHandler().exception(e, new RuntimeException("Unable to get the bot named " + name + ", its not loaded or not enabled."));
        }
        if (bot == null) {
            botArray = new Bot[]{};
        } else {
            Bot[] botArray2 = new Bot[1];
            botArray = botArray2;
            botArray2[0] = bot;
        }
        return botArray;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Bot> getReturnType() {
        return Bot.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "bot named " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerExpression(GetBot.class, Bot.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[get] [the] bot [(named|with name)] %string%"});
    }
}

