/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.getters.BaseGetterExpression;

@Name(value="Get Channel")
@Description(value={"A generic expression to get any channel from its ID.", "This can return a text, private, news, voice, category, stage, thread or post channel."})
@Examples(value={"post last embed to channel with id \"000\""})
@Since(value={"4.4.2"})
public class GetChannel
extends BaseGetterExpression<Channel> {
    @Override
    protected Channel get(String id, Bot bot) {
        Channel channel = bot.getInstance().getTextChannelById(id);
        if (channel != null) {
            return channel;
        }
        channel = bot.getInstance().getVoiceChannelById(id);
        if (channel != null) {
            return channel;
        }
        channel = bot.getInstance().getCategoryById(id);
        if (channel != null) {
            return channel;
        }
        channel = bot.getInstance().getStageChannelById(id);
        if (channel != null) {
            return channel;
        }
        channel = bot.getInstance().getNewsChannelById(id);
        if (channel != null) {
            return channel;
        }
        channel = bot.getInstance().getPrivateChannelById(id);
        if (channel != null) {
            return channel;
        }
        channel = bot.getInstance().getForumChannelById(id);
        if (channel != null) {
            return channel;
        }
        channel = bot.getInstance().getThreadChannelById(id);
        return channel;
    }

    @Override
    public String getCodeName() {
        return "channel";
    }

    public Class<? extends Channel> getReturnType() {
        return Channel.class;
    }

    static {
        GetChannel.register(GetChannel.class, Channel.class, "channel");
    }
}

