/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.getters.BaseGetterExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Get Forum Channel")
@Description(value={"Get a forum channel from a guild using its unique ID.", "Channels are global on discord, means different forum channels cannot have the same ID.", "This expression cannot be changed."})
@Examples(value={"forum channel with id \"000\""})
public class GetForumChannel
extends BaseGetterExpression<ForumChannel> {
    @Override
    protected ForumChannel get(String id, Bot bot) {
        return bot.getInstance().getForumChannelById(id);
    }

    @Override
    public String getCodeName() {
        return "forum channel";
    }

    @NotNull
    public Class<? extends ForumChannel> getReturnType() {
        return ForumChannel.class;
    }

    static {
        GetForumChannel.register(GetForumChannel.class, ForumChannel.class, "forum channel");
    }
}

