/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.changers.IAsyncGettableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Get Member")
@Description(value={"Get a cached member from its unique ID", "This expression could return null, according to if the actual member was cached or not.", "To be sure it will return the corresponding member, use the retrieve member effect.", "This expression cannot be changed"})
@Examples(value={"member with id \"000\" in event-guild"})
public class GetMember
extends SimpleExpression<Member>
implements IAsyncGettableExpression<Member> {
    private Expression<String> exprId;
    private Expression<Guild> exprGuild;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprId = exprs[0];
        this.exprGuild = exprs[1];
        return true;
    }

    protected Member @NotNull [] get(@NotNull Event e) {
        String id = (String)this.exprId.getSingle(e);
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (EasyElement.anyNull(this, id, guild)) {
            return new Member[0];
        }
        return new Member[]{guild.getMemberById(id)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Member> getReturnType() {
        return Member.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "member with id " + this.exprId.toString(e, debug) + " in " + this.exprGuild.toString(e, debug);
    }

    public Member[] getAsync(Event e) {
        String id = (String)this.exprId.getSingle(e);
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (EasyElement.anyNull(this, id, guild)) {
            return new Member[0];
        }
        Member member = guild.getMemberById(id);
        if (member != null) {
            return new Member[]{member};
        }
        try {
            member = (Member)guild.retrieveMemberById(id).complete();
        }
        catch (Exception ex) {
            DiSky.getErrorHandler().exception(e, ex);
            return new Member[0];
        }
        return new Member[]{member};
    }

    static {
        Skript.registerExpression(GetMember.class, Member.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[get] [the] member with id %string% (from|in|of) [the] [guild] %guild%"});
    }
}

