/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.getters.BaseGetterExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Get Message Channel")
@Description(value={"This is an utility expression.", "It will returns a Message Channel (text, news or thread) out of the provided ID.", "This expression cannot be changed."})
@Examples(value={"message channel with id \"000\""})
@Since(value={"4.0.0"})
public class GetMessageChannel
extends BaseGetterExpression<GuildMessageChannel> {
    @Override
    protected GuildMessageChannel get(String id, Bot bot) {
        TextChannel text = bot.getInstance().getTextChannelById(id);
        if (text != null) {
            return text;
        }
        NewsChannel news = bot.getInstance().getNewsChannelById(id);
        if (news != null) {
            return news;
        }
        ThreadChannel thread = bot.getInstance().getThreadChannelById(id);
        if (thread != null) {
            return thread;
        }
        return null;
    }

    @Override
    public String getCodeName() {
        return "message channel";
    }

    @NotNull
    public Class<? extends GuildMessageChannel> getReturnType() {
        return GuildMessageChannel.class;
    }

    static {
        GetMessageChannel.register(GetMessageChannel.class, GuildMessageChannel.class, "message channel");
    }
}

