/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.changers.IAsyncGettableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="User in Guild")
@Description(value={"Get the member related to the specified user in a specific guild.", "Users are common to whole Discord, two user cannot have the same instance.", "Members are common to guilds, but also holding an user as reference.", "User can have multiple instance according to which guild they are in, therefore they are considered as member."})
public class GetUserInGuild
extends SimpleExpression<Member>
implements IAsyncGettableExpression<Member> {
    private Expression<User> exprUser;
    private Expression<Guild> exprGuild;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprUser = exprs[0];
        this.exprGuild = exprs[1];
        return true;
    }

    protected Member @NotNull [] get(@NotNull Event e) {
        User user = EasyElement.parseSingle(this.exprUser, e, null);
        Guild guild = EasyElement.parseSingle(this.exprGuild, e, null);
        if (EasyElement.anyNull(this, user, guild)) {
            return new Member[0];
        }
        return new Member[]{guild.getMember(user)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Member> getReturnType() {
        return Member.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return this.exprUser.toString(e, debug) + " in " + this.exprGuild.toString(e, debug);
    }

    public Member[] getAsync(Event e) {
        User user = EasyElement.parseSingle(this.exprUser, e, null);
        Guild guild = EasyElement.parseSingle(this.exprGuild, e, null);
        if (EasyElement.anyNull(this, user, guild)) {
            return new Member[0];
        }
        return new Member[]{(Member)guild.retrieveMember(user).complete()};
    }

    static {
        Skript.registerExpression(GetUserInGuild.class, Member.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%user% in [the] [guild] %guild%"});
    }
}

