/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.itsthesky.disky.DiSky;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Last DiSky Exception")
@Description(value={"Return the last occurred DiSky or Discord exception in the current event.", "This expression is event-based, means you cannot get the last error that happened on another event.", "Once this has been called, it will remove the returned value from the errors list to avoid having two times the same error message."})
@Examples(value={"if last disky exception is set: # an error occurred"})
public class LastDiSkyException
extends SimpleExpression<String> {
    protected String @NotNull [] get(@NotNull Event e) {
        @Nullable Throwable throwable = DiSky.getErrorHandler().getErrorValue(e);
        if (throwable == null) {
            return new String[0];
        }
        return new String[]{throwable.getMessage()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the last disky exception";
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        return true;
    }

    static {
        Skript.registerExpression(LastDiSkyException.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] last (disky|discord) (error|exception)"});
    }
}

