/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.dv8tion.jda.api.managers.GuildManager;
import net.dv8tion.jda.api.managers.Manager;
import net.itsthesky.disky.api.changers.ChangeableSimplePropertyExpression;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.INodeHolder;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="User / Bot / Guild Avatar")
@Description(value={"Return the avatar URL of any user, guild or bot.", "This can be changed for guilds and bots only!"})
@Examples(value={"avatar of event-guild", "avatar of event-user"})
public class AvatarURL
extends ChangeableSimplePropertyExpression<Object, String>
implements IAsyncChangeableExpression,
INodeHolder {
    private Node node;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Override
    @NotNull
    public Node getNode() {
        return this.node;
    }

    @NotNull
    protected String getPropertyName() {
        return "avatar";
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (EasyElement.equalAny(mode, Changer.ChangeMode.SET, Changer.ChangeMode.RESET, Changer.ChangeMode.DELETE)) {
            return new Class[]{String.class};
        }
        return new Class[0];
    }

    @Nullable
    public String convert(Object entity) {
        if (entity instanceof Bot) {
            return ((Bot)entity).getInstance().getSelfUser().getEffectiveAvatarUrl();
        }
        if (entity instanceof Guild) {
            return ((Guild)entity).getIconUrl();
        }
        if (entity instanceof User) {
            return ((User)entity).getEffectiveAvatarUrl();
        }
        if (entity instanceof Member) {
            return ((Member)entity).getEffectiveAvatarUrl();
        }
        if (entity instanceof Sticker) {
            return ((Sticker)entity).getIconUrl();
        }
        if (entity instanceof ApplicationInfo) {
            return ((ApplicationInfo)entity).getIconUrl();
        }
        return null;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        this.change(e, delta, mode, false);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode, boolean async) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        String value = (String)delta[0];
        Object entity = EasyElement.parseSingle(this.getExpr(), e, null);
        if (entity == null || entity instanceof User) {
            return;
        }
        Manager<GuildManager> action = null;
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            if (entity instanceof Guild) {
                Guild guild = entity;
                action = guild.getManager().setIcon(null);
            }
            if (entity instanceof Bot) {
                Bot bot = entity;
                action = bot.getInstance().getSelfUser().getManager().setAvatar(null);
            }
        } else {
            Icon parsedIcon = SkriptUtils.parseIcon(value);
            if (parsedIcon == null) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("Cannot parse the given icon URL: " + value), this.node);
                return;
            }
            if (entity instanceof Guild) {
                Guild guild = entity;
                action = guild.getManager().setIcon(parsedIcon);
            } else if (entity instanceof Bot) {
                Bot bot = entity;
                action = bot.getInstance().getSelfUser().getManager().setAvatar(parsedIcon);
            }
        }
        if (action != null) {
            if (async) {
                action.complete();
            } else {
                action.queue();
            }
        }
    }

    static {
        AvatarURL.register(AvatarURL.class, String.class, (String)"avatar [url]", (String)"guild/user/sticker/member/bot/applicationinfo");
    }
}

