/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.config.Node;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChannelOf
extends SimplePropertyExpression<Object, GuildChannel> {
    private Node node;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public GuildChannel convert(Object entity) {
        if (entity instanceof Message) {
            Message message2 = (Message)entity;
            MessageChannelUnion channel = message2.getChannel();
            if (channel.getType().isGuild() && channel.getType().isMessage()) {
                return channel.asGuildMessageChannel();
            }
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The given message (" + message2.getId() + ") is not in a guild text channel, therefore it cannot have a channel attached to it. "), this.node, false);
            return null;
        }
        if (entity instanceof Webhook) {
            Webhook webhook = (Webhook)entity;
            if (webhook.getChannel().getType().equals((Object)ChannelType.FORUM)) {
                return webhook.getChannel().asForumChannel();
            }
            if (webhook.getChannel().getType().isGuild() && webhook.getChannel().getType().isMessage()) {
                return webhook.getChannel().asGuildMessageChannel();
            }
        }
        return null;
    }

    @NotNull
    protected String getPropertyName() {
        return "discord channel";
    }

    @NotNull
    public Class<? extends GuildChannel> getReturnType() {
        return GuildChannel.class;
    }

    static {
        ChannelOf.register(ChannelOf.class, GuildChannel.class, (String)"[discord] [(message|webhook)] [text]( |-)channel", (String)"message/webhook");
    }
}

