/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import java.awt.Color;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.managers.RoleManager;
import net.itsthesky.disky.api.changers.ChangeableSimplePropertyExpression;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Embed Color")
@Description(value={"Get or change the color of an embed builder.", "The color input must come from Skript, and will be converted by DiSky."})
@Examples(value={"set embed color of embed to red"})
public class ColorOf
extends ChangeableSimplePropertyExpression<Object, ch.njol.skript.util.Color>
implements IAsyncChangeableExpression {
    @Override
    public void change(@NotNull Event e, @NotNull Object[] delta, Bot bot, @NotNull Changer.ChangeMode mode) {
        this.change(e, delta, mode, false);
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode, boolean async) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        Object entity = EasyElement.parseSingle(this.getExpr(), e, null);
        if (entity == null) {
            return;
        }
        Color target = null;
        if (mode == Changer.ChangeMode.SET) {
            ch.njol.skript.util.Color color = (ch.njol.skript.util.Color)delta[0];
            target = new Color(color.asBukkitColor().asRGB());
        }
        if (entity instanceof Role) {
            Role role = entity;
            RoleManager action = role.getManager().setColor(target);
            if (async) {
                action.complete();
            } else {
                action.queue();
            }
        } else if (entity instanceof EmbedBuilder) {
            ((EmbedBuilder)entity).setColor(target);
        }
    }

    public Class<?> @Nullable [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{ch.njol.skript.util.Color.class};
        }
        return null;
    }

    @NotNull
    public Class<? extends ch.njol.skript.util.Color> getReturnType() {
        return ch.njol.skript.util.Color.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "color";
    }

    @Nullable
    public ch.njol.skript.util.Color convert(Object entity) {
        if (entity instanceof EmbedBuilder) {
            return ((EmbedBuilder)entity).isEmpty() ? null : SkriptUtils.convert(((EmbedBuilder)entity).build().getColor());
        }
        if (entity instanceof Role) {
            return SkriptUtils.convert(((Role)entity).getColor());
        }
        return null;
    }

    static {
        ColorOf.register(ColorOf.class, ch.njol.skript.util.Color.class, (String)"(embed|discord) colo[u]r", (String)"embedbuilder");
    }
}

