/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import java.util.TimeZone;
import net.dv8tion.jda.api.entities.ISnowflake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Creation Date")
@Description(value={"Get the creation date (as Skript date) of any ISnowFlake entity, including, but not limited to:", "- Member", "- User", "- Role", "- Guild", "- Channel", "- etc..."})
@Examples(value={"creation date of event-user", "created date of event-member"})
public class CreationDate
extends SimplePropertyExpression<ISnowflake, Date> {
    @NotNull
    protected String getPropertyName() {
        return "creation date";
    }

    @Nullable
    public Date convert(ISnowflake o) {
        return new Date(o.getTimeCreated().toInstant().toEpochMilli(), TimeZone.getTimeZone("GMT"));
    }

    @NotNull
    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        CreationDate.register(CreationDate.class, Date.class, (String)"creat(ion|ed) date", (String)"guild/member/user/role/channel/message/emote/webhook");
    }
}

