/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.dv8tion.jda.api.entities.IMentionable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Mention Tag")
@Description(value={"Get the mention name of the discord entity.", "It will return the similar format that when you are doing @ (roles, users) or # (channels) followed by names."})
@Examples(value={"mention tag of event-channel", "mention tag of channel with id \"000\""})
public class MentionTag
extends SimplePropertyExpression<IMentionable, String> {
    @NotNull
    protected String getPropertyName() {
        return "mention tag";
    }

    @Nullable
    public String convert(IMentionable mentionable) {
        return mentionable.getAsMention();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        MentionTag.register(MentionTag.class, String.class, (String)"mention [tag]", (String)"channel/role/user/emote/member");
    }
}

