/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprPermissions;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.HashSet;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.DiSkyRegistry;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.registration.SyntaxRegistry;

@Name(value="Discord Permissions Of")
@Description(value={"Get or change the permissions of a specific member or role in an optional channel."})
@Examples(value={"add (manage server) to permissions of event-member in event-channel", "remove (administrator) from permissions of event-role"})
@Since(value={"4.0.0"})
public class PermissionsOf
extends SimpleExpression<Object>
implements IAsyncChangeableExpression {
    private Expression<Object> exprHolder;
    private Expression<GuildChannel> exprChannel;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprHolder = exprs[0];
        this.exprChannel = exprs[1];
        return true;
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET) {
            return new Class[]{Permission[].class, Permission.class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        this.change(e, delta, mode, false);
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    protected Object @NotNull [] get(@NotNull Event e) {
        Object[] objects = EasyElement.parseList(this.exprHolder, e, null);
        if (objects == null) {
            return new Permission[0];
        }
        HashSet<Player> players = new HashSet<Player>();
        for (Object object : objects) {
            if (!(object instanceof Player)) continue;
            players.add((Player)object);
        }
        if (!players.isEmpty()) {
            HashSet<String> permissions = new HashSet<String>();
            for (Player player : players) {
                for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
                    permissions.add(permission.getPermission());
                }
            }
            return permissions.toArray(new String[0]);
        }
        IPermissionHolder holder = EasyElement.parseSingle(this.exprHolder, e, null);
        @Nullable GuildChannel channel = EasyElement.parseSingle(this.exprChannel, e, null);
        if (EasyElement.anyNull(this, holder)) {
            return new Permission[0];
        }
        if (channel != null && !(channel instanceof GuildChannel)) {
            return new Permission[0];
        }
        if (channel == null) {
            return holder.getPermissions().toArray(new Permission[0]);
        }
        return holder.getPermissions(channel).toArray(new Permission[0]);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode, boolean async) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        IPermissionHolder holder = EasyElement.parseSingle(this.exprHolder, e, null);
        @Nullable GuildChannel channel = EasyElement.parseSingle(this.exprChannel, e, null);
        Permission[] perms = (Permission[])delta;
        if (EasyElement.anyNull(this, new Object[]{holder, perms})) {
            return;
        }
        ArrayList<AuditableRestAction<Void>> actions = new ArrayList<AuditableRestAction<Void>>();
        switch (mode) {
            case ADD: {
                if (holder instanceof Role && channel == null) {
                    actions.add(((Role)holder).getManager().givePermissions(perms));
                }
                if (channel == null) break;
                actions.add(channel.getPermissionContainer().upsertPermissionOverride(holder).grant(perms));
                break;
            }
            case REMOVE: {
                if (holder instanceof Role && channel == null) {
                    actions.add(((Role)holder).getManager().revokePermissions(perms));
                }
                if (channel == null) break;
                actions.add(channel.getPermissionContainer().upsertPermissionOverride(holder).deny(perms));
                break;
            }
            case REMOVE_ALL: 
            case RESET: {
                if (holder instanceof Role && channel == null) {
                    DiSky.getInstance().getLogger().warning("You cannot clear/reset permissions of a role, without a target channel!");
                }
                if (channel == null) break;
                actions.add(channel.getPermissionContainer().upsertPermissionOverride(holder).clear(perms));
            }
        }
        if (actions.isEmpty()) {
            return;
        }
        RestAction action = RestAction.allOf(actions);
        if (async) {
            action.complete();
        } else {
            action.queue();
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "discord permissions of " + this.exprHolder.toString(e, debug) + (String)(this.exprChannel != null ? " in " + this.exprChannel.toString(e, debug) : "");
    }

    static {
        if (DiSkyRegistry.unregisterElement(SyntaxRegistry.EXPRESSION, ExprPermissions.class)) {
            DiSky.debug("Unregistered the original 'permissions' expression, to replace it with a new one.");
        } else {
            Skript.error((String)"DiSky were unable to unregister the original 'permissions' expression, please report this error to the developer.");
        }
        Skript.registerExpression(PermissionsOf.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(all [[of] the]|the)] [discord] permissions of %member/role/player% [in %-channel/guildchannel%]", "[(all [[of] the]|the)] %member/role/player%'s [discord] permissions [in %-channel/guildchannel%]"});
    }
}

