/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.itsthesky.disky.api.events.specific.InteractionEvent;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="User Locale")
@Description(value={"Get the language code defined as user-side client of Discord.", "Basically, return the language user's client is loaded in.", "This expression only works in interactions event, and cannot be used outside of them."})
@Examples(value={"the user locale"})
public class UserLocal
extends SimpleExpression<String> {
    protected String @NotNull [] get(@NotNull Event e) {
        GenericInteractionCreateEvent event = ((InteractionEvent)e).getInteractionEvent();
        return new String[]{event.getUserLocale().toString()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the user locale language";
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!EasyElement.containsInterfaces(InteractionEvent.class)) {
            Skript.error((String)"The 'user locale' expression can only be used in interaction events.");
            return false;
        }
        return true;
    }

    static {
        Skript.registerExpression(UserLocal.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] user['s] local[e] [(code|language)]"});
    }
}

