/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.attachments;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Message;
import org.bukkit.event.Event;

@Name(value="Is Attachment Image")
@Description(value={"See if a specific attachment is an image."})
@Since(value={"1.7"})
public class CondIsImage
extends Condition {
    private Expression<Message.Attachment> exprAtt;
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprAtt = exprs[0];
        this.pattern = matchedPattern;
        return true;
    }

    public boolean check(Event e) {
        Message.Attachment att = (Message.Attachment)this.exprAtt.getSingle(e);
        if (att == null) {
            return false;
        }
        if (this.pattern == 0) {
            return att.isImage();
        }
        return !att.isImage();
    }

    public String toString(Event e, boolean debug) {
        return "attachment " + String.valueOf(this.exprAtt) + " is an image";
    }

    static {
        Skript.registerCondition(CondIsImage.class, (String[])new String[]{"att[achment[s]] %attachment% is [an] (image|img)", "att[achment[s]] %attachment% (isn't|is not|wasn't|was not) [an] (image|img)"});
    }
}

